/*****************************************************************************
*  LPC11U6x_E6x SCT demo program
*
*  Use SCT timer capture and capture control features. It implements a
*  PWM decoder which measures the duty cycle of a PWM signal and determines
*  whether it is above (max_width) or below (min_width) a specific value.
*  The PWM signal frequency is assumed to be 10 kHz. Two output signals
*  (width_error and timeout) are included to indicate when the 10 kHz signal
*  has an error or is missing.
*****************************************************************************/
#include "nxp_lpc11u6x.h"

extern void SCT1_Init(void);

void SCT0_1_IRQHandler(void)
{
  uint32_t status = LPC_SCT1->EVFLAG;

    if (status & 1)                                    // EVENT 0: timeout
    {
		/* New measurement result */
		;
    }

    if (status & (1 << 5))                             // EVENT 5: width error
    {
		/* Time-out (no signal) */
		;
    }
    LPC_SCT1->EVFLAG = status;                         // Acknowledge interrupts
}

int main (void)
{
  volatile static int i = 0;                           // force counter to be placed into memory

    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)            // enable clock for IOCON
                               | (1u << 31);           // enable clock for SCT0/1

    LPC_IOCON->PIO2_8  = 0x00000081;                   // P2_8  is SCT1_IN0  = PWM signal input
    LPC_IOCON->PIO2_16 = 0x00000081;                   // P2_16 is SCT1_OUT0 = timeout (red LED)
    LPC_IOCON->PIO2_17 = 0x00000081;                   // P2_17 is SCT1_OUT1 = width_error (green LED)

    SCT1_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
       	/* The settings are chosen in % of duty cycle (assuming a PWM frequency of 10 kHz).
       	 * (In a real world application you want to select better resolution!)
       	 */
        i = LPC_SCT1->CAP[4].U;
    }
}
